#if !defined _PCMAG_ORA8_H_
#define _PCMAG_ORA8_H_

// set to TRUE to not use Benchmark Factory's database driver infrastructure (as a workaround for BF bugs with Oracle 8.1.5 client libraries)
#define _NOBF_ORA8_ FALSE

// set to TRUE to add extra test mixes to the benchmark
#define _EXTRA_MIXES_ TRUE

// set _ORASKIP_ to TRUE to skip certain queries Oracle is very slow at executing
#define _ORASKIP_ FALSE

// Benchmark Factory include files
#include "CSSBFC.h"
#include "CSSBenchmark.h"
#include "ctimer.h"
#if (_NOBF_ORA8_ == FALSE)
	#include "BFC_ORA8.h"
#else
	#include "NOBF_ORA8.h"
#endif

// declare and initialize constants
const ub4 NUM_ROWS = 100;					// fetch rows in 100 row blocks

// define transaction class IDs
const int XID_OLTP_READ_SELECT = 1000;
const int XID_OLTP_READ_JOIN = 1100;
const int XID_OLTP_WRITE = 1200;
const int XID_DSS_SELECT = 1300;

// group names for transaction groups
enum
{
	OLTPReadSelect,
	OLTPReadJoin,
	OLTPWrite,
	DSSSelect
};

// class prototypes
class AFX_EXT_CLASS PCMAG_ORA8 : public CSSBenchmark
{
	DECLARE_SERIAL(PCMAG_ORA8)

public:

	PCMAG_ORA8 (void);
	~PCMAG_ORA8 (void);
	virtual BOOL RegisterTransactions (BOOL bRegisterObjectXact = FALSE);

};

// macros
#define CHECK_FOR_ERROR \
	if (ReturnCode != OCI_SUCCESS) { \
		m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes); \
		CString szErrorMsg; \
		szErrorMsg.Format ("OCI error in CHECK_FOR_ERROR! ReturnCode = %i", ReturnCode); \
		CSSOutputDebugText (szErrorMsg); \
		pSQLDatabaseServer->HandleError ((WORD)ReturnCode, pError); \
		ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT); \
		return FALSE; \
	}

#define CHECK_FOR_ERROR_EXECUTE \
	if (ExecuteReturnCode != OCI_SUCCESS && ExecuteReturnCode != OCI_NO_DATA) { \
		m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes); \
		CString szErrorMsg; \
		szErrorMsg.Format ("OCI error in CHECK_FOR_ERROR_EXECUTE! ReturnCode = %i", ExecuteReturnCode); \
		CSSOutputDebugText (szErrorMsg); \
		pSQLDatabaseServer->HandleError ((WORD)ReturnCode, pError); \
		ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT); \
		return FALSE; \
	}

#endif
